<?php
    $category = $category ?? null;
    $locale = request()->locale ?? app()->getLocale();
    $translations = [];
    if ($category && $locale) {
        $translations = parse_translation($category, $locale);
    }
    $title = $translations['title'] ?? $category->title ?? '';
    $metaTitle = $translations['meta_title'] ?? $category->meta_title ?? '';
    $metaDescription = $translations['meta_description'] ?? $category->meta_description ?? '';
?>

<?php if (isset($component)) { $__componentOriginald7f77a02f879fd4954ea3c39c4e952cb = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald7f77a02f879fd4954ea3c39c4e952cb = $attributes; } ?>
<?php $component = Modules\LMS\View\Components\Dashboard\Layout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Modules\LMS\View\Components\Dashboard\Layout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('title', null, []); ?> <?php echo e(isset($category) ? translate('Edit') : translate('Create')); ?> <?php echo e(translate('Category')); ?>

     <?php $__env->endSlot(); ?>
    <!-- BREADCRUMB -->
    <?php if (isset($component)) { $__componentOriginalcf27f2c2c873893339708d5fdeeb6984 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalcf27f2c2c873893339708d5fdeeb6984 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => '7ee9c4f86007ba41bc79bbfab1cd8a68::admin.breadcrumb','data' => ['backUrl' => ''.e(route('category.index')).'','title' => ''.e(isset($category) ? 'Edit' : 'Create').'','pageTo' => 'Category']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('portal::admin.breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['back-url' => ''.e(route('category.index')).'','title' => ''.e(isset($category) ? 'Edit' : 'Create').'','page-to' => 'Category']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalcf27f2c2c873893339708d5fdeeb6984)): ?>
<?php $attributes = $__attributesOriginalcf27f2c2c873893339708d5fdeeb6984; ?>
<?php unset($__attributesOriginalcf27f2c2c873893339708d5fdeeb6984); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalcf27f2c2c873893339708d5fdeeb6984)): ?>
<?php $component = $__componentOriginalcf27f2c2c873893339708d5fdeeb6984; ?>
<?php unset($__componentOriginalcf27f2c2c873893339708d5fdeeb6984); ?>
<?php endif; ?>

    <?php if(is_active('category.translate') === 'active'): ?>
        <div class="flex items-center justify-end gap-4 mb-2">
            <h2 class="card-title"><?php echo e(translate('Translate Language')); ?></h2>
            <form method="GET" class="sm:block" id="change-translate-language">
                <select onchange="window.location.href=this.options[this.selectedIndex].value" name="id"
                    class="text-gray-500 dark:text-dark-text dark:bg-dark-card-shade font-semibold bg-white focus:outline-none cursor-pointer select-none text-sm border dk-border-one px-2 py-2 rounded-md dk-theme-card-square">
                    <?php $__currentLoopData = app('languages'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($lang->code); ?>" <?php echo e($locale == $lang->code ? 'selected' : ''); ?>>
                            <?php echo e($lang->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </form>
        </div>
    <?php endif; ?>

    <form action="<?php echo e(isset($category) ? route('category.update', $category->id) : route('category.store')); ?>"
        method="post" class="form mb-4" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php if(isset($category)): ?>
            <?php echo method_field('PUT'); ?>
            <input type="hidden" name="locale" class="form-input" value="<?php echo e($locale ?? ''); ?>">
        <?php endif; ?>
        <div class="grid grid-cols-12 gap-x-4">
            <div class="col-span-full lg:col-span-6 card">
                <div class="leading-none">
                    <label for="title" class="form-label">
                        <?php echo e(translate('Title')); ?>

                        <span class="text-danger" title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                    </label>
                    <input type="text" id="title" name="title"
                        value="<?php echo e($title); ?>" class="form-input">
                    <span class="text-danger error-text title_err"></span>
                </div>
                <?php if(is_active('category.edit') === 'active'): ?>
                    <div class="leading-none mt-6">
                        <label for="parent_id" class="form-label"><?php echo e(translate('Parent')); ?></label>
                        <select data-select id="parent_id" name="parent_id" class="singleSelect">
                            <option selected disabled
                                data-display="<?php echo e(translate('Select none to create a parent category')); ?>">
                                <?php echo e(translate('Select none to create a parent category')); ?>

                            </option>
                            <?php $__currentLoopData = get_all_category(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pcat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($pcat->id); ?>"
                                    <?php echo e(isset($category) && $pcat->id == $category->parent_id ? 'selected' : ''); ?>>
                                    <?php echo e($pcat->title); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="leading-none mt-6">
                        <label for="icon" class="form-label"><?php echo e(translate('Icon picker')); ?> </label>
                        <select data-select id="icon" name="icon_id" class="singleSelect">
                            <option selected disabled data-display="<?php echo e(translate('Selected Icon')); ?>">
                                <?php echo e(translate('Selected Icon')); ?>

                            </option>
                            <?php $__currentLoopData = get_all_icon(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $icon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($icon->id); ?>"
                                    <?php echo e(isset($category) && $icon->id == $category->icon_id ? 'selected' : ''); ?>>
                                    <?php echo e($icon->icon); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="leading-none mt-6">
                        <label for="order" class="form-label">
                            <?php echo e(translate('Category Position')); ?>

                        </label>
                        <input type="number" id="order" name="order" class="form-input"
                            placeholder="<?php echo e(translate('Enter Position')); ?>" value="<?php echo e($category->order ?? null); ?>">
                    </div>
                <?php endif; ?>
                <div class="leading-none mt-6">
                    <label for="meta_title" class="form-label">
                        <?php echo e(translate('Meta Title')); ?>

                    </label>
                    <input type="text" id="meta_title" name="meta_title"
                        value="<?php echo e($metaTitle); ?>" class="form-input"
                        placeholder="<?php echo e(translate('Enter Meta Title')); ?>">
                </div>
            </div>
            <?php if(is_active('category.edit') === 'active' || is_active('category.create') === 'active'): ?>
                <div class="col-span-full lg:col-span-6 card">
                    <label for="imgage"
                        class="dropzone-wrappe mb-4 file-container ac-bg text-xs leading-none font-semibold cursor-pointer w-full h-[200px] flex flex-col items-center justify-center gap-2.5 border border-dashed border-gray-900 rounded-10">
                        <input type="file" hidden name="thumbnail" id="imgage"
                            class="dropzone dropzone-image img-src peer/file">
                        <span class="flex-center flex-col peer-[.uploaded]/file:hidden">
                            <img src="<?php echo e(asset('lms/')); ?>/assets/images/icons/upload-file.svg" alt="file-icon"
                                class="size-8 lg:size-auto">
                            <div class="text-gray-500 dark:text-dark-text mt-2"> <?php echo e(translate('Choose file')); ?> </div>
                        </span>
                        <span class="text-danger error-text thumbnail_err"></span>
                    </label>
                    <div class="preview-zone dropzone-preview">
                        <div class="box box-solid">
                            <div class="box-body flex items-center gap-2 flex-wrap">
                                <?php if(isset($category) &&
                                        fileExists($folder = 'lms/categories', $fileName = $category->image) == true &&
                                        $category->image !== ''): ?>
                                    <div class="img-thumb-wrapper">
                                        <img class="img-thumb"
                                            src="<?php echo e(asset('storage/lms/categories/' . $category->image)); ?>"
                                            alt="">
                                    </div>
                                <?php else: ?>
                                    <div class="img-thumb-wrapper max-w-[120px] max-h-[120px]">
                                        <button class="remove text-danger">
                                            <i class="ri-close-line text-inherit text-[13px]"></i>
                                        </button>
                                        <img id="preview_img" width="auto" height="auto">
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <div class="col-span-full card">
                <label for="meta_description" class="form-label">
                    <?php echo e(translate('Meta Description')); ?>

                </label>
                <textarea name="meta_description" id="meta_description" class="summernote"> <?php echo clean($metaDescription); ?></textarea>
            </div>
            <div class="col-span-full card flex justify-end">
                <button type="submit" class="btn b-solid btn-primary-solid w-max dk-theme-card-square">
                    <?php echo e(isset($category) ? translate('Update') : translate('Save')); ?>

                </button>
            </div>
        </div>
    </form>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald7f77a02f879fd4954ea3c39c4e952cb)): ?>
<?php $attributes = $__attributesOriginald7f77a02f879fd4954ea3c39c4e952cb; ?>
<?php unset($__attributesOriginald7f77a02f879fd4954ea3c39c4e952cb); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald7f77a02f879fd4954ea3c39c4e952cb)): ?>
<?php $component = $__componentOriginald7f77a02f879fd4954ea3c39c4e952cb; ?>
<?php unset($__componentOriginald7f77a02f879fd4954ea3c39c4e952cb); ?>
<?php endif; ?>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\admin\category\form.blade.php ENDPATH**/ ?>