<article>
    <h2 class="area-title text-xl mb-5">
        <?php echo e(translate('Course Assignments')); ?>

    </h2>
    <div class="overflow-x-auto">
        <table class="table-auto w-full whitespace-nowrap border-separate border-spacing-x-0 border-spacing-y-2">
            <tbody>
                <?php $__currentLoopData = $assignments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $assignment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="px-4 py-3 rounded-row-border">
                            <div class="flex items-center gap-2">
                                <i class="ri-draft-line"></i>
                                <h6 class="area-title text-base !leading-none font-bold">
                                    <?php echo e($key + 1); ?> . <?php echo e($assignment?->topicable?->title); ?>

                                </h6>
                            </div>
                        </td>
                        <td class="px-4 py-3 rounded-row-border">
                            <?php echo e(customDateFormate($assignment?->created_at, 'D m Y')); ?>

                        </td>
                        <td class="px-4 py-3 rounded-row-border">
                            <?php
                                $userExam = userAssignmentCheck($assignment?->topicable->id);
                                $passMark = $assignment?->topicable?->pass_mark ?? null;
                                $class = 'badge-warning-outline';
                                $status = 'pending';
                                if ($userExam && $passMark <= $userExam->score) {
                                    $class = 'badge-success-outline';
                                    $status = 'Pass';
                                } elseif ($userExam && $passMark > $userExam->score) {
                                    $class = 'badge-danger-outline';
                                    $status = 'Failed';
                                } else {
                                    $class = 'badge-primary-outline';
                                    $status = 'No Submit';
                                }
                            ?>
                            <span
                                class="badge <?php echo e($class); ?> b-outline rounded-full"><?php echo e(translate($status)); ?></span>
                        </td>
                        <td class="px-4 py-3 rounded-row-border w-10">
                            <a href="<?php echo e(route('exam.start', ['course_id' => $assignment->course_id, 'type' => 'assignment', 'exam_type_id' => $assignment?->topicable->id])); ?>"
                                class="btn b-light btn-primary-light btn-sm !rounded-full"
                                aria-label="View assignment link">
                                <i class="ri-eye-line"></i>
                                <?php echo e(translate('View')); ?>

                            </a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</article>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\course\assignment.blade.php ENDPATH**/ ?>