<?php
    $blog = $blog ?? null;
    $translations = [];
    if ($blog) {
        $translations = parse_translation($blog);
    }
    $title = $translations['title'] ?? $blog->title ?? '';
    $description = $translations['description'] ?? $blog->description ?? '';
    $thumbnail =
        $blog->thumbnail && fileExists('lms/blogs/', $blog->thumbnail) == true
            ? asset("storage/lms/blogs/{$blog->thumbnail}")
            : asset('lms/frontend/assets/images/450x300.svg');
?>
<?php if (isset($component)) { $__componentOriginal4ea3ceba530d619a977e9c813ff095c4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4ea3ceba530d619a977e9c813ff095c4 = $attributes; } ?>
<?php $component = Modules\LMS\View\Components\Frontend\Layout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('frontend-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Modules\LMS\View\Components\Frontend\Layout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <?php if (isset($component)) { $__componentOriginal633e9714cbfc155a1e1afb58682cfb8f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal633e9714cbfc155a1e1afb58682cfb8f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'f484570d7cf557020e11ace406901b10::breadcrumbs.breadcrumb-one','data' => ['pageTitle' => 'Blog Detail','pageRoute' => ''.e(route('blog.list')).'','pageName' => 'Blog Detail']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('theme::breadcrumbs.breadcrumb-one'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['pageTitle' => 'Blog Detail','pageRoute' => ''.e(route('blog.list')).'','pageName' => 'Blog Detail']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal633e9714cbfc155a1e1afb58682cfb8f)): ?>
<?php $attributes = $__attributesOriginal633e9714cbfc155a1e1afb58682cfb8f; ?>
<?php unset($__attributesOriginal633e9714cbfc155a1e1afb58682cfb8f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal633e9714cbfc155a1e1afb58682cfb8f)): ?>
<?php $component = $__componentOriginal633e9714cbfc155a1e1afb58682cfb8f; ?>
<?php unset($__componentOriginal633e9714cbfc155a1e1afb58682cfb8f); ?>
<?php endif; ?>

    <div class="container">
        <div class="grid grid-cols-12 gap-5">
            <!-- START BLOG DETAILS CONTENT -->
            <div class="col-span-full lg:col-span-8">
                <div class="flex justify-end lg:hidden">
                    <button type="button" aria-label="Off-canvas drawer" data-offcanvas-id="blog-filter-drawer"
                        class="btn b-outline btn-secondary-outline">
                        <i class="ri-equalizer-line"></i>
                        <?php echo e(translate('Filter')); ?>

                    </button>
                </div>
                <div class="mt-6 lg:mt-0">
                    <div class="aspect-video rounded-xl overflow-hidden">
                        <img data-src="<?php echo e($thumbnail); ?>" class="size-full object-cover"
                            alt="<?php echo e(translate('Blog thumbnail')); ?>">
                    </div>
                    <!-- BLOG META DATA -->
                    <div class="flex-center-between my-7">
                        <div class="flex items-center flex-wrap gap-x-5 gap-y-2">
                            <!-- category -->
                            <?php if(isset($blog->blogCategories) && !empty($blog->blogCategories)): ?>
                                <?php $__currentLoopData = $blog->blogCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($loop->first): ?>
                                        <?php $categoryTranslations = parse_translation($category); ?>
                                        <div class="badge b-solid badge-secondary-solid rounded-full !text-heading shrink-0">
                                            <a href="<?php echo e(route('blog.list', ['category' => $category->id])); ?>"
                                                aria-label="Category link">
                                                <?php echo e($categoryTranslations['name'] ?? $category->name ?? ''); ?>

                                            </a>
                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            <!-- date -->
                            <div class="flex items-center gap-1 area-description text-sm !leading-none shrink-0">
                                <i class="ri-calendar-2-line"></i>
                                <span><?php echo e(customDateFormate($blog->created_at, format: 'd M Y')); ?></span>
                            </div>
                            <!-- comment -->
                            <div class="flex items-center gap-1 area-description text-sm !leading-none shrink-0">
                                <i class="ri-message-3-line"></i>
                                <span> <?php echo e($blog?->comments?->count() ?? 0); ?> <?php echo e(translate('Comments')); ?></span>
                            </div>
                        </div>

                    </div>
                    <div class="[&>:not(:first-child)]:mt-14">
                        <!-- DETAILS -->
                        <article class="blog-details-content">
                            <h3 class="area-title xl:text-[40px] mb-5"><?php echo e($title); ?></h3>
                            <div>
                                <?php echo clean($description); ?>

                            </div>
                        </article>
                        <!-- COMMENTS -->
                        <?php if (isset($component)) { $__componentOriginalb80154e508bfa5418995814c462952b4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalb80154e508bfa5418995814c462952b4 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'f484570d7cf557020e11ace406901b10::comments.blog-comment','data' => ['blog' => $blog]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('theme::comments.blog-comment'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['blog' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($blog)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalb80154e508bfa5418995814c462952b4)): ?>
<?php $attributes = $__attributesOriginalb80154e508bfa5418995814c462952b4; ?>
<?php unset($__attributesOriginalb80154e508bfa5418995814c462952b4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalb80154e508bfa5418995814c462952b4)): ?>
<?php $component = $__componentOriginalb80154e508bfa5418995814c462952b4; ?>
<?php unset($__componentOriginalb80154e508bfa5418995814c462952b4); ?>
<?php endif; ?>
                    </div>
                </div>
            </div>
            <!-- END BLOG DETAILS CONTENT -->

            <!-- START BLOG SIDEBAR -->
            <?php if (isset($component)) { $__componentOriginal2a7dbea1837afa925cfd8bcc67c0dffe = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal2a7dbea1837afa925cfd8bcc67c0dffe = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'f484570d7cf557020e11ace406901b10::blog.sidebar','data' => ['blog' => $blog]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('theme::blog.sidebar'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['blog' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($blog)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal2a7dbea1837afa925cfd8bcc67c0dffe)): ?>
<?php $attributes = $__attributesOriginal2a7dbea1837afa925cfd8bcc67c0dffe; ?>
<?php unset($__attributesOriginal2a7dbea1837afa925cfd8bcc67c0dffe); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal2a7dbea1837afa925cfd8bcc67c0dffe)): ?>
<?php $component = $__componentOriginal2a7dbea1837afa925cfd8bcc67c0dffe; ?>
<?php unset($__componentOriginal2a7dbea1837afa925cfd8bcc67c0dffe); ?>
<?php endif; ?>
            <!-- END BLOG SIDEBAR -->
        </div>
    </div>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4ea3ceba530d619a977e9c813ff095c4)): ?>
<?php $attributes = $__attributesOriginal4ea3ceba530d619a977e9c813ff095c4; ?>
<?php unset($__attributesOriginal4ea3ceba530d619a977e9c813ff095c4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4ea3ceba530d619a977e9c813ff095c4)): ?>
<?php $component = $__componentOriginal4ea3ceba530d619a977e9c813ff095c4; ?>
<?php unset($__componentOriginal4ea3ceba530d619a977e9c813ff095c4); ?>
<?php endif; ?>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\theme\blog\blog-detail.blade.php ENDPATH**/ ?>